<!DOCTYPE html>
<html>
<head>
  <title>PAYE Calculator</title>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
  <h1>PAYE Calculator - 0 dependent</h1>
  
  <label for="income">Income Amount:</label>
  <input type="number" id="income" name="income">
  
  <button id="calculateBtn">Calculate PAYE</button>
  
  <div id="payeResult"></div>
  
  <script>
    $(document).ready(function() {
      $('#calculateBtn').click(function() {
        var income = parseInt($('#income').val());
        
        // Calculate the PAYE
        var paye = calculatePAYE(income);
        
        // Display the result
        $('#payeResult').text('PAYE: ' + paye);
      });
    });
    
    function calculatePAYE(income) {
      var brackets = [
        { amount: 390000, rate: 0 },
        { amount: 40000, rate: 0.02 },
        { amount: 40000, rate: 0.04 },
        { amount: 60000, rate: 0.06 },
        { amount: 60000, rate: 0.08 },
        { amount: 300000, rate: 0.1 },
        { amount: 300000, rate: 0.12 },
        { amount: 300000, rate: 0.14 },
        { amount: 400000, rate: 0.16 },
        { amount: 500000, rate: 0.18 },
        { amount: 500000000, rate: 0.20 }
      ];
      
      var paye = 0;
      
      for (var i = 0; i < brackets.length; i++) {
        if (income > 0) {
          var bracketAmount = Math.min(income, brackets[i].amount);
          var bracketTax = bracketAmount * brackets[i].rate;
          paye += bracketTax;
          income -= bracketAmount;
        } else {
          break;
        }
      }
      
      return paye;
    }
  </script>
</body>
</html>
