<?php
include('funcGetValueFromTable.php');
// CSG CALCULATIONS

function getCSGEmployee(int $basicSalary,$db) {

  $employee_less_50000 = valueFromTable("employee_less_50000",$db);
  $employee_greater_50000 = valueFromTable("employee_greater_50000",$db);

  $csgValue = 0;
  if ($basicSalary <= 50000) {
    $csgValue = ( $employee_less_50000 / 100 ) * $basicSalary;    
  } else if ($basicSalary >= 50000) {
    $csgValue = ( $employee_greater_50000 / 100 ) * $basicSalary;
  }

  return round($csgValue,0);

}

function getCSGEmployer(int $basicSalary,$db) {

  $employer_less_50000 = valueFromTable("employer_less_50000",$db);
  $employer_greater_50000 = valueFromTable("employer_greater_50000",$db);

  $csgValue = 0;
  if ($basicSalary <= 50000) {
    $csgValue = ( $employer_less_50000 / 100 ) * $basicSalary;
  } else if ($basicSalary >= 50000) {
    $csgValue = ( $employer_greater_50000 / 100 ) * $basicSalary;
  }

  return round($csgValue,0);

}

// NSF CALCULATIONS
function getNSFEmployer(int $basicSalary,$db) {

  $nsfThreshold = valueFromTable("nsfThreshold",$db);
  $employer_nsf = valueFromTable("employer_nsf",$db);

  $nsfValue = 0;
  if ($basicSalary <= $nsfThreshold) {
    $nsfValue = ( $employer_nsf / 100 ) * $basicSalary;    
  } else {
    $nsfValue = ( $employer_nsf / 100 ) * $nsfThreshold;
  }

  return round($nsfValue,0);

}

function getNSFEmployee(int $basicSalary,$db) {

  $nsfThreshold = valueFromTable("nsfThreshold",$db);
  $employee_nsf = valueFromTable("employee_nsf",$db);

  $nsfValue = 0;
  if ($basicSalary <= $nsfThreshold) {
    $nsfValue = ( $employee_nsf / 100 ) * $basicSalary;    
  } else {
    $nsfValue = ( $employee_nsf / 100 ) * $nsfThreshold;
  }

  return round($nsfValue,0);

}

//LEVY Calculations
function getLevyEmployer(int $basicSalary,$db) {

  $employer_levy = valueFromTable("employer_levy",$db);

  $levyValue = $basicSalary * ($employer_levy / 100);

  return round($levyValue,0);

}


//PAYE Calculations
function getPAYE(int $edfamount, int $totalIncome) {

  $payeamount = 0;

  $paye_less_650000 = 10;
  $paye_greater_650000 = 15;

  $taxableIncome = $totalIncome - ($edfamount / 13);

  if ($edfamount <= 650000) {
    $payeamount = $taxableIncome * ($paye_less_650000 / 100);
  } else if ($edfamount > 650000) {
    $payeamount = $taxableIncome * ($paye_greater_650000 / 100);
  }

  return round($payeamount,0);

}

//NPS Calculations
function getNPS(int $basicSalary) {

  $employee_nps = 3;

  $npsValue = $basicSalary * ($employee_nps / 100);

  return round($npsValue,0);

}

?>